<?php
/**
 * ============================================
 * 🛡️ SNIPPET DE PROTEÇÃO - COLE NO SEU CHECKOUT
 * ============================================
 * 
 * Este arquivo deve ser incluído no TOPO de cada
 * página do seu checkout/site real que quer proteger.
 * 
 * Como usar:
 * 1. Faça upload deste arquivo para seu checkout
 * 2. No topo de cada página PHP, adicione:
 *    require_once 'protecao.php';
 */

// ========== CONFIGURAÇÕES ==========
$CONFIG = [
    // Token secreto - DEVE SER O MESMO do Cloaker
    'token' => 'RIFA_PROTECT_2025',
    
    // Para onde redirecionar se bloqueado
    'redirect' => 'https://google.com/',
    
    // Permitir acesso direto? (sem vir do cloaker)
    'allow_direct' => false,
    
    // Bloquear DevTools?
    'block_devtools' => true,
    
    // Bloquear iframe? (anti-clone)
    'block_iframe' => true,
    
    // Bloquear clique direito?
    'block_rightclick' => true,
    
    // Tempo da sessão (segundos)
    'session_time' => 3600,
    
    // Domínios permitidos como referer (seus domínios do cloaker)
    'allowed_domains' => [
        'oferta01.com',
        'rifamoto.com',
        // Adicione seus domínios aqui
    ],
];

// ========== NÃO EDITE ABAIXO ==========

session_start();

// Verifica token na URL (vindo do cloaker)
if (isset($_GET['_t'])) {
    $expected = md5($CONFIG['token'] . date('Y-m-d'));
    if ($_GET['_t'] === $expected) {
        $_SESSION['_prot_valid'] = true;
        $_SESSION['_prot_time'] = time();
        $_SESSION['_prot_ip'] = $_SERVER['REMOTE_ADDR'];
        
        // Remove token da URL
        $url = strtok($_SERVER['REQUEST_URI'], '?');
        $params = $_GET;
        unset($params['_t']);
        if ($params) $url .= '?' . http_build_query($params);
        header("Location: $url");
        exit;
    }
}

// Verifica sessão
$blocked = false;
$reason = '';

if (!$CONFIG['allow_direct']) {
    if (!isset($_SESSION['_prot_valid']) || !$_SESSION['_prot_valid']) {
        $blocked = true;
        $reason = 'no_session';
    } elseif (time() - $_SESSION['_prot_time'] > $CONFIG['session_time']) {
        $blocked = true;
        $reason = 'expired';
    }
}

// Verifica bot
$ua = strtolower($_SERVER['HTTP_USER_AGENT'] ?? '');
$bots = ['bot','crawler','spider','curl','wget','python','phantom','headless','selenium'];
foreach ($bots as $b) {
    if (strpos($ua, $b) !== false) {
        $blocked = true;
        $reason = 'bot';
        break;
    }
}

// Bloqueia
if ($blocked) {
    header('Location: ' . $CONFIG['redirect']);
    exit;
}

// Headers de segurança
if ($CONFIG['block_iframe']) {
    header('X-Frame-Options: DENY');
    header("Content-Security-Policy: frame-ancestors 'none'");
}
header('X-Content-Type-Options: nosniff');

// JavaScript de proteção
$js_devtools = $CONFIG['block_devtools'] ? 'true' : 'false';
$js_iframe = $CONFIG['block_iframe'] ? 'true' : 'false';
$js_rightclick = $CONFIG['block_rightclick'] ? 'true' : 'false';
$js_redirect = $CONFIG['redirect'];

$protection_js = <<<SCRIPT
<script>
(function(){
    var R='$js_redirect';
    
    // Anti-iframe
    if($js_iframe && top!==self){top.location=R;return;}
    
    // Anti-DevTools
    if($js_devtools){
        setInterval(function(){
            if(window.outerWidth-window.innerWidth>160||window.outerHeight-window.innerHeight>160)
                location=R;
        },1000);
        document.addEventListener('keydown',function(e){
            if(e.keyCode===123||(e.ctrlKey&&e.shiftKey&&(e.keyCode===73||e.keyCode===74))||(e.ctrlKey&&e.keyCode===85)){
                e.preventDefault();return false;
            }
        });
    }
    
    // Anti-clique direito
    if($js_rightclick){
        document.addEventListener('contextmenu',function(e){e.preventDefault();return false;});
    }
    
    // Anti-copy
    document.addEventListener('copy',function(e){e.preventDefault();});
    document.body.style.userSelect='none';
    
    // Detecta automação
    if(navigator.webdriver||window.callPhantom||window._phantom)location=R;
    
    console.log('%c⚠️ PROTEGIDO','color:red;font-size:24px;font-weight:bold');
})();
</script>
SCRIPT;

// Injeta o JS automaticamente
register_shutdown_function(function() use ($protection_js) {
    $content = ob_get_clean();
    if (strpos($content, '</head>') !== false) {
        echo str_replace('</head>', $protection_js . '</head>', $content);
    } else {
        echo $protection_js . $content;
    }
});
ob_start();
