# 🛡️ Guia de Proteção Anti-Clone

## O que está incluso?

### 1️⃣ Proteção no CLOAKER (já ativa)
- ✅ Filtro de bots e crawlers
- ✅ Bloqueio de VPN/Datacenter
- ✅ Verificação geográfica
- ✅ Token de tráfego obrigatório
- ✅ Fingerprint do dispositivo

### 2️⃣ Proteção no CHECKOUT (você precisa ativar)
- ✅ Verificação de sessão válida
- ✅ Bloqueio de iframe (anti-clone)
- ✅ Bloqueio de DevTools
- ✅ Bloqueio de clique direito
- ✅ Bloqueio de cópia de texto
- ✅ Detecção de automação

---

## 🚀 Como Ativar a Proteção no Checkout

### Opção 1: Snippet Simples (Recomendado)

1. Faça upload do arquivo `protecao.php` para seu checkout

2. No **TOPO** de cada página PHP do seu checkout, adicione:
```php
<?php
require_once 'protecao.php';
?>
<!DOCTYPE html>
...resto do seu HTML...
```

3. Configure os domínios permitidos no arquivo:
```php
'allowed_domains' => [
    'oferta01.com',
    'rifamoto.com',
    // Adicione SEUS domínios do cloaker
],
```

### Opção 2: Classe Completa (Mais controle)

```php
<?php
require_once 'AntiClone.php';

$protection = new AntiClone([
    'secret_token' => 'RIFA_PROTECT_2025',
    'block_redirect' => 'https://google.com/',
    'allow_direct' => false,
    'block_iframe' => true,
    'block_devtools' => true,
    'block_bots' => true,
    'allowed_referers' => ['oferta01.com', 'rifamoto.com'],
]);

$protection->protect();
?>
```

---

## 🔄 Como Funciona o Fluxo

```
1. Tráfego chega no Cloaker
   ↓
2. Cloaker valida (token, país, device, etc)
   ↓
3. Se PASSOU → Redireciona para Checkout COM token secreto
   URL: checkout.com/?_t=abc123&utm_source=fb
   ↓
4. Checkout recebe e valida token
   ↓
5. Token válido → Cria sessão → Remove token da URL
   ↓
6. Usuário navega normalmente no checkout
   ↓
7. Proteção JS ativa (anti-devtools, anti-iframe, etc)
```

---

## 🛡️ O que cada proteção faz

### Anti-Iframe
```
Impede que seu site seja carregado dentro de um iframe.
Clonadores usam iframe para "copiar" seu site.
```

### Anti-DevTools
```
Detecta quando o usuário abre o F12/Inspecionar.
Se abrir → Redireciona para página safe.
```

### Anti-Clique Direito
```
Bloqueia o menu de contexto (botão direito).
Dificulta "Salvar página como".
```

### Anti-Cópia
```
Bloqueia Ctrl+C e seleção de texto.
Impede copiar código fonte facilmente.
```

### Verificação de Sessão
```
Só permite acesso se vier do Cloaker.
Acesso direto ao checkout = Bloqueado.
```

### Detecção de Automação
```
Detecta Selenium, Puppeteer, PhantomJS.
Ferramentas usadas para scraping/clonagem.
```

---

## ⚠️ Importante

### Token de Proteção
O token muda **todo dia**. É calculado assim:
```php
$token = md5('RIFA_PROTECT_2025' . date('Y-m-d'));
```

O Cloaker e o Checkout devem usar o **mesmo secret**.

### Domínios
Configure os domínios do seu Cloaker na whitelist:
```php
'allowed_domains' => ['oferta01.com', 'rifamoto.com'],
```

### Logs
Os logs ficam em `logs/anticlone.log`:
```
2025-01-13 10:30:00 | 189.45.67.89 | ALLOWED | Score: 100 | valid_session
2025-01-13 10:31:00 | 45.67.89.12 | BLOCKED | Score: 20 | no_session,bot
```

---

## 🔧 Configurações Avançadas

### Permitir Acesso Direto (não recomendado)
```php
'allow_direct' => true,
```

### Desativar Bloqueio de DevTools
```php
'block_devtools' => false,
```

### Adicionar IPs na Whitelist
```php
'whitelist_ips' => ['SEU.IP.AQUI', '127.0.0.1'],
```

### Bloquear Países Específicos
```php
'blocked_countries' => ['US', 'RU', 'CN'],
```

---

## 📊 Níveis de Proteção

| Nível | Configuração |
|-------|-------------|
| **Básico** | Só verificação de sessão |
| **Médio** | + Anti-iframe + Anti-bot |
| **Alto** | + Anti-DevTools + Anti-copy |
| **Paranóico** | Tudo ativado + whitelist de IPs |

### Configuração Recomendada (Nível Alto):
```php
$CONFIG = [
    'token' => 'RIFA_PROTECT_2025',
    'redirect' => 'https://google.com/',
    'allow_direct' => false,
    'block_devtools' => true,
    'block_iframe' => true,
    'block_rightclick' => true,
    'session_time' => 3600,
];
```

---

## ❓ FAQ

**P: Usuários legítimos são bloqueados?**
R: Não, se vieram pelo Cloaker com token válido.

**P: E se o usuário usar VPN?**
R: O Cloaker já bloqueia VPN antes de chegar no checkout.

**P: Funciona em WordPress/outras plataformas?**
R: Sim! Basta incluir o PHP no header do tema.

**P: O clonador consegue copiar mesmo assim?**
R: Dificultamos muito. Proteção 100% não existe, mas essas barreiras eliminam 99% das tentativas.

**P: Afeta o SEO?**
R: Não. Googlebot é bloqueado, mas você não quer indexar seu checkout mesmo.

---

## ✅ Checklist de Proteção

- [ ] Cloaker configurado e funcionando
- [ ] Arquivo `protecao.php` no checkout
- [ ] Domínios configurados na whitelist
- [ ] Token secreto igual no Cloaker e Checkout
- [ ] Testou acesso normal (via cloaker) - OK
- [ ] Testou acesso direto (sem cloaker) - Bloqueado
- [ ] Testou abrir DevTools - Redirecionado
- [ ] Testou em iframe - Bloqueado
- [ ] Logs funcionando

🎉 **Checkout protegido!**
